# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 5
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR5_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR5(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Check for unconditional strategies in opponent's code
    if "always D" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    if "always C" in opponent_program_code or "return 'C'" in opponent_program_code:
        if current_round == 1:
            return "C"
        else:
            return "D"
    
    # Round 1: Cooperate
    if current_round == 1:
        return "C"
    
    # Rounds 2-3: Tit-for-tat
    if current_round <= 3:
        return opp_history[-1]
    
    # Middle Rounds (4-7)
    if current_round <= 7:
        # Check opponent's behavior in first 3 rounds
        opp_defects_first_3 = sum(1 for move in opp_history[:3] if move == "D")
        if opp_defects_first_3 >= 2:
            return "D"
        else:
            return opp_history[-1]
    
    # Final Rounds (8-10)
    opp_cooperations = sum(1 for move in opp_history if move == "C")
    cooperation_rate = opp_cooperations / len(opp_history)
    
    if cooperation_rate >= 0.7:
        return "D"
    else:
        return "D"